/*===========================================================*/
/* Common include file		           		     */
/*===========================================================*/

#ifndef _COMMON_H_
#define _COMMON_H_


#include <avr/sfr_defs.h>
#include <avr/io.h>
#include <avr/interrupt.h>


/*------------------------------------------------*/
/* Macros definitions                             */ 
/*------------------------------------------------*/

#define BIT(x)		(1 << (x))

#define _asm		asm			/* old style */

#define WDR() 		asm("wdr")
#define SEI()		asm("sei")
#define CLI()		asm("cli")
#define SLEEP()		asm("sleep")
#define NOP()		asm("nop")
#define _WDR() 		asm("wdr")
#define _SEI()		asm("sei")
#define _CLI()		asm("cli")
#define _SLEEP() 	asm("sleep")
#define _NOP()		asm("nop")

// Frequency of crystal in Hz
#define F_CPU		16000000LU


/*------------------------------------------------*/
/* Signal bit definitions                         */ 
/*------------------------------------------------*/

// outputs
#define		LED_RD		BIT(7)	// PE7
#define		LED_GR		BIT(6)	// PE6

//misc
#define		SPK		BIT(5)	// PB5


/*------------------------------------------------*/
/* Types definitions                              */ 
/*------------------------------------------------*/

#endif 

