// =====================================================
//
//   miniPOI Data uploader
//
//   (c) MSP 2007
//
// =====================================================
//
// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This software is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this package; see the file COPYING.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <windows.h>
#include <winbase.h>

#include "serial.h"
#include "avr.h"

//***************************************************************************

#define VERSION		"1.0"

#define FLASH_OFFSET	32768
#define MAXLENGTH	97280


typedef struct tPOISet_str
{
   unsigned char	type;
   char			*filename;
   long			size;
   struct tPOISet_str	*p_next;
} tPOISet;

tPOISet	*p_poi_start, *p_poi_item, **pp_poi_item; 


// ------------------------------------------------------------------------
//  Main
// ------------------------------------------------------------------------

int main(int argc, char *argv[])
{
   int	i;
   unsigned int poi_type;

   unsigned int fnum;
   unsigned long int fsize, tsize;
   //struct stat file_stat;
   FILE *p_infile;
   unsigned char data;
   unsigned long int flash_ptr, eeprom_ptr;
   unsigned int comport;


   p_poi_item = NULL;
   pp_poi_item = &p_poi_start;
   comport = 1;

   
   // -----------------------
   // read arguments
   // -----------------------
   for (i=1;i<argc;i++)
   {
      if (   (strcmp(argv[i],"-h")==0)
	  || (strcmp(argv[i],"-?")==0)
	  || (argc == 1))
      {
	 printf("POI converter "VERSION"\n");
	 printf("\n");
	 printf("  -h -?       - help screen\n");
	 printf("  -aN,FILE    - add POI file, N = POI type (0-9)\n");
	 printf("  -cN         - COM number, default 1\n");
	 return 0;
      }
    
      
      // add poi
      else if (argv[i][1]=='a')
      {
	 sscanf(argv[i]+2,"%u",&poi_type);
	 if ((poi_type > 3) || ((argv[i][3]) != ','))
	 {
	    fprintf(stderr, "Incorrect poi type (%s)\n", argv[i]);
	    return(1);
	 }


	 p_poi_item = (tPOISet*)malloc(sizeof(tPOISet));
	 p_poi_item->type = poi_type;
	 p_poi_item->filename = argv[i]+4;
	 p_poi_item->p_next = NULL;
	 *pp_poi_item = p_poi_item;
	 pp_poi_item = &(p_poi_item->p_next);
	 
      }

      // COM number
      else if (argv[i][1]=='c')
      {
	 sscanf(argv[i]+2,"%u",&comport);
      }

 
      else
      {
	 fprintf(stderr,"Unknown parameter %s.\n", argv[i]);
	 return(1);
      }

   }

   // -----------------------
   // Start 
   // -----------------------


   // enter programming mode
   printf("Entering programming mode\n");
   ser_init(comport, 4800, 1);
   ser_sendbuffer((unsigned char*)"$PROG!\x0D", 7);
   ser_close();/**/

   // wait for miniPOI
   Sleep(1000);

   // initialize bootloader
   printf("Updating data\n");
   ser_init(comport, 115200, 1);
   avr_EnterProgrammingMode();
   

   // start
   p_poi_item = p_poi_start;
   flash_ptr = FLASH_OFFSET;
   eeprom_ptr = 0;
   tsize = 0;
   fnum = 0;

   // program loop
   // TODO - add verification of data
   while (p_poi_item != NULL)
   {
      fnum++;

      // open file
      p_infile = fopen(p_poi_item->filename, "rb");
      if (p_infile == NULL)
      {
	 fprintf(stderr, "Unable to open input file: %s\n", p_poi_item->filename);
	 return(1);
      }

      // TODO - recognize POI header and perform basic format checks

      // read file and convert
      fsize = 0;
      while (!feof(p_infile))
      {
	 fread(&data, sizeof(data), 1, p_infile);
	 fsize++;
	 tsize++;
	 
	 avr_WriteByte(SEG_FLASH, flash_ptr+fsize-1, data);

	 if ((fsize % 256) == 0)
	    printf("#");
      }

      // FIXME - check size of POI header
      if (fsize < 5)
      {
	 fprintf(stderr, "Number of data below limit (5)\n");
	 return(1);
      }
      
      // POI type
      avr_WriteByte(SEG_EEPROM, eeprom_ptr++, p_poi_item->type);
      // POI address
      avr_WriteByte(SEG_EEPROM, eeprom_ptr++, flash_ptr&0xFF);
      avr_WriteByte(SEG_EEPROM, eeprom_ptr++, (flash_ptr&0xFF00)>>8);
      avr_WriteByte(SEG_EEPROM, eeprom_ptr++, (flash_ptr&0xFF0000)>>16);
      avr_WriteByte(SEG_EEPROM, eeprom_ptr++, 0);
      // POI size
      avr_WriteByte(SEG_EEPROM, eeprom_ptr++, fsize&0xFF);
      avr_WriteByte(SEG_EEPROM, eeprom_ptr++, (fsize&0xFF00)>>8);
      avr_WriteByte(SEG_EEPROM, eeprom_ptr++, (fsize&0xFF0000)>>16);
      avr_WriteByte(SEG_EEPROM, eeprom_ptr++, 0);

      flash_ptr += fsize;

      fclose(p_infile);
      printf("\n");
      printf("Added %s, type:%d, size:%ld\n", p_poi_item->filename, p_poi_item->type, fsize);
      
      // next poi
      p_poi_item = p_poi_item->p_next;
   }

   // final cleanup
   avr_FlushWriteBuffer();
   avr_WriteByte(SEG_EEPROM, eeprom_ptr++, 0xFF);	// signalize last POI set
   avr_LeaveProgrammingMode();
   printf("\nProgram finished. Converted %d file(s), total size:%ld\n\n", fnum, tsize);
}



